/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CompileState;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.MasterControl;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrderedBin;
import javax.media.j3d.OrderedPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.VirtualUniverse;

class OrderedGroupRetained
extends GroupRetained {
    int[] orderedChildIdTable;
    private int orderedChildIdCount = 0;
    private ArrayList orderedChildIdFreeList = new ArrayList();
    OrderedBin[] orderedBin = new OrderedBin[0];
    Integer newChildId;
    int childCount = 0;
    ArrayList childrenOrderedPaths = new ArrayList(1);
    int[] userChildIndexOrder = null;
    int[] childIndexOrder = null;

    OrderedGroupRetained() {
        this.nodeType = 20;
    }

    void setChildIndexOrder(int[] nArray) {
        if (nArray != null) {
            if (this.userChildIndexOrder == null || this.userChildIndexOrder.length != nArray.length) {
                this.userChildIndexOrder = new int[nArray.length];
            }
            System.arraycopy(nArray, 0, this.userChildIndexOrder, 0, this.userChildIndexOrder.length);
        } else {
            this.userChildIndexOrder = null;
        }
        if (this.source.isLive()) {
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 59;
            j3dMessage.universe = this.universe;
            j3dMessage.args[3] = this;
            j3dMessage.args[4] = nArray2;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    int[] getChildIndexOrder() {
        if (this.userChildIndexOrder == null) {
            return null;
        }
        int[] nArray = new int[this.userChildIndexOrder.length];
        System.arraycopy(this.userChildIndexOrder, 0, nArray, 0, this.userChildIndexOrder.length);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer getOrderedChildId() {
        Integer n2;
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            if (this.orderedChildIdFreeList.size() == 0) {
                n2 = new Integer(this.orderedChildIdCount);
                ++this.orderedChildIdCount;
            } else {
                n2 = (Integer)this.orderedChildIdFreeList.remove(0);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeOrderedChildId(int n2) {
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            this.orderedChildIdFreeList.add(new Integer(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getOrderedChildCount() {
        int n2;
        ArrayList arrayList = this.orderedChildIdFreeList;
        synchronized (arrayList) {
            n2 = this.orderedChildIdCount;
        }
        return n2;
    }

    void addChild(Node node) {
        if (this.userChildIndexOrder != null) {
            this.doAddChildIndexEntry();
        }
        super.addChild(node);
    }

    void addChild(Node node, int[] nArray) {
        if (nArray != null) {
            this.userChildIndexOrder = new int[nArray.length];
            System.arraycopy(nArray, 0, this.userChildIndexOrder, 0, this.userChildIndexOrder.length);
        } else {
            this.userChildIndexOrder = null;
        }
        super.addChild(node);
    }

    void moveTo(BranchGroup branchGroup) {
        if (this.userChildIndexOrder != null) {
            this.doAddChildIndexEntry();
        }
        super.moveTo(branchGroup);
    }

    void doRemoveChildIndexEntry(int n2) {
        int[] nArray = new int[this.userChildIndexOrder.length - 1];
        int n3 = 0;
        for (int i2 = 0; i2 < this.userChildIndexOrder.length; ++i2) {
            if (this.userChildIndexOrder[i2] > n2) {
                nArray[n3] = this.userChildIndexOrder[i2] - 1;
                ++n3;
                continue;
            }
            if (this.userChildIndexOrder[i2] >= n2) continue;
            nArray[n3] = this.userChildIndexOrder[i2];
            ++n3;
        }
        this.userChildIndexOrder = nArray;
    }

    void doAddChildIndexEntry() {
        int[] nArray = new int[this.userChildIndexOrder.length + 1];
        System.arraycopy(this.userChildIndexOrder, 0, nArray, 0, this.userChildIndexOrder.length);
        nArray[this.userChildIndexOrder.length] = this.userChildIndexOrder.length;
        this.userChildIndexOrder = nArray;
    }

    void compile(CompileState compileState) {
        super.compile(compileState);
        this.mergeFlag = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOrderedBin(OrderedBin orderedBin, int n2) {
        OrderedBin[] orderedBinArray = this.orderedBin;
        synchronized (this.orderedBin) {
            this.orderedBin[n2] = orderedBin;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OrderedBin getOrderedBin(int n2) {
        OrderedBin[] orderedBinArray = this.orderedBin;
        synchronized (this.orderedBin) {
            if (n2 >= this.orderedBin.length) {
                OrderedBin[] orderedBinArray2 = new OrderedBin[n2 + 1];
                for (int i2 = 0; i2 < this.orderedBin.length; ++i2) {
                    orderedBinArray2[i2] = this.orderedBin[i2];
                }
                orderedBinArray2[n2] = null;
                this.orderedBin = orderedBinArray2;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return this.orderedBin[n2];
        }
    }

    void updateChildIdTableInserted(int n2, int n3) {
        int n4;
        int n5 = 0;
        if (this.orderedChildIdTable != null) {
            n5 = this.orderedChildIdTable.length;
            for (n4 = 0; n4 < n5; ++n4) {
                if (this.orderedChildIdTable[n4] == -1 || this.orderedChildIdTable[n4] < n2) continue;
                int n6 = n4;
                this.orderedChildIdTable[n6] = this.orderedChildIdTable[n6] + 1;
            }
        }
        if (n3 >= n5) {
            int[] nArray = new int[n3 + 1];
            if (n5 > 0) {
                System.arraycopy(this.orderedChildIdTable, 0, nArray, 0, this.orderedChildIdTable.length);
            } else {
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    nArray[n4] = -1;
                }
            }
            this.orderedChildIdTable = nArray;
        }
        this.orderedChildIdTable[n3] = n2;
    }

    void updateChildIdTableRemoved(int n2) {
        if (this.orderedChildIdTable == null) {
            return;
        }
        for (int i2 = 0; i2 < this.orderedChildIdTable.length; ++i2) {
            if (this.orderedChildIdTable[i2] == -1) continue;
            if (this.orderedChildIdTable[i2] > n2) {
                int n3 = i2;
                this.orderedChildIdTable[n3] = this.orderedChildIdTable[n3] - 1;
                continue;
            }
            if (this.orderedChildIdTable[i2] != n2) continue;
            this.orderedChildIdTable[i2] = -1;
            this.freeOrderedChildId(i2);
        }
    }

    void setAuxData(SetLiveState setLiveState, int n2, int n3) {
        OrderedPath orderedPath = (OrderedPath)setLiveState.orderedPaths.get(n3);
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            NodeRetained nodeRetained = (NodeRetained)this.children.get(i2);
            if (this.refCount == setLiveState.refCount) {
                nodeRetained.orderedId = this.getOrderedChildId();
            }
            OrderedPath orderedPath2 = orderedPath.clonePath();
            orderedPath2.addElementToPath(this, nodeRetained.orderedId);
            ArrayList arrayList = (ArrayList)this.childrenOrderedPaths.get(i2);
            arrayList.add(n3, orderedPath2);
        }
    }

    void setLive(SetLiveState setLiveState) {
        super.setLive(setLiveState);
        setLiveState.orderedPaths = this.orderedPaths;
        if (this.userChildIndexOrder != null && this.refCount == 1) {
            int[] nArray = new int[this.userChildIndexOrder.length];
            System.arraycopy(this.userChildIndexOrder, 0, nArray, 0, this.userChildIndexOrder.length);
            this.childIndexOrder = nArray;
        }
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        if (this.refCount == 0) {
            setLiveState.notifyThreads |= 0x1000;
            setLiveState.nodeList.add(this);
            setLiveState.ogCIOList.add(this);
            setLiveState.ogCIOTableList.add(null);
            this.userChildIndexOrder = null;
        }
        setLiveState.orderedPaths = this.orderedPaths;
    }

    void setNodeData(SetLiveState setLiveState) {
        super.setNodeData(setLiveState);
        if (!this.inSharedGroup) {
            this.setAuxData(setLiveState, 0, 0);
        } else {
            for (int i2 = 0; i2 < setLiveState.keys.length; ++i2) {
                int n2 = setLiveState.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n2 >= 0) {
                    this.setAuxData(setLiveState, i2, n2);
                    continue;
                }
                MasterControl.getCoreLogger().severe("Can't Find matching hashKey in setNodeData.");
            }
        }
    }

    void removeNodeData(SetLiveState setLiveState) {
        if (this.inSharedGroup && setLiveState.keys.length != this.localToVworld.length) {
            for (int i2 = setLiveState.keys.length - 1; i2 >= 0; --i2) {
                int n2 = setLiveState.keys[i2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n2 < 0) continue;
                for (int i3 = 0; i3 < this.children.size(); ++i3) {
                    ArrayList arrayList = (ArrayList)this.childrenOrderedPaths.get(i3);
                    arrayList.remove(n2);
                }
            }
        }
        super.removeNodeData(setLiveState);
    }

    void clearDerivedDataStructures() {
        int n2;
        for (n2 = 0; n2 < this.orderedBin.length; ++n2) {
            if (this.orderedBin[n2] == null) continue;
            this.orderedBin[n2].source = null;
            this.orderedBin[n2] = null;
        }
        if (this.orderedChildIdTable != null) {
            for (n2 = 0; n2 < this.orderedChildIdTable.length; ++n2) {
                if (this.orderedChildIdTable[n2] == -1) continue;
                this.orderedChildIdTable[n2] = -1;
                this.freeOrderedChildId(n2);
            }
            this.orderedChildIdTable = null;
        }
    }

    void incrChildCount() {
        ++this.childCount;
    }

    void decrChildCount() {
        --this.childCount;
    }

    void printTable(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            System.err.print(" " + nArray[i2]);
        }
        System.err.println("");
    }

    void insertChildrenData(int n2) {
        this.childrenOrderedPaths.add(n2, new ArrayList(1));
    }

    void appendChildrenData() {
        this.childrenOrderedPaths.add(new ArrayList(1));
    }

    void doRemoveChild(int n2, J3dMessage[] j3dMessageArray, int n3) {
        if (this.userChildIndexOrder != null) {
            this.doRemoveChildIndexEntry(n2);
        }
        super.doRemoveChild(n2, j3dMessageArray, n3);
    }

    void removeChildrenData(int n2) {
        this.childrenOrderedPaths.remove(n2);
    }

    void childDoSetLive(NodeRetained nodeRetained, int n2, SetLiveState setLiveState) {
        if (this.refCount == setLiveState.refCount) {
            setLiveState.ogList.add(this);
            setLiveState.ogChildIdList.add(new Integer(n2));
            setLiveState.ogOrderedIdList.add(nodeRetained.orderedId);
        }
        setLiveState.orderedPaths = (ArrayList)this.childrenOrderedPaths.get(n2);
        if (nodeRetained != null) {
            nodeRetained.setLive(setLiveState);
        }
    }

    void childCheckSetLive(NodeRetained nodeRetained, int n2, SetLiveState setLiveState, NodeRetained nodeRetained2) {
        ArrayList arrayList;
        if (nodeRetained2 != null) {
            int n3 = this.children.indexOf(nodeRetained2);
            arrayList = (ArrayList)this.childrenOrderedPaths.get(n3);
        } else {
            nodeRetained.orderedId = this.getOrderedChildId();
            setLiveState.ogList.add(this);
            setLiveState.ogChildIdList.add(new Integer(n2));
            setLiveState.ogOrderedIdList.add(nodeRetained.orderedId);
            if (this.userChildIndexOrder != null) {
                setLiveState.ogCIOList.add(this);
                int[] nArray = new int[this.userChildIndexOrder.length];
                System.arraycopy(this.userChildIndexOrder, 0, nArray, 0, this.userChildIndexOrder.length);
                setLiveState.ogCIOTableList.add(nArray);
            }
            arrayList = (ArrayList)this.childrenOrderedPaths.get(n2);
            for (int i2 = 0; i2 < this.orderedPaths.size(); ++i2) {
                OrderedPath orderedPath = ((OrderedPath)this.orderedPaths.get(i2)).clonePath();
                orderedPath.addElementToPath(this, nodeRetained.orderedId);
                arrayList.add(orderedPath);
            }
        }
        setLiveState.orderedPaths = arrayList;
        nodeRetained.setLive(setLiveState);
    }
}

